varying vec2 		texcoord;
uniform sampler2D 	tex,
					bump,
					diff;
vec3 				normal;
uniform float 		alpha;


void main()
{
	normal=texture2D(bump,texcoord).xyz*2.0-1.0;
	vec4 color=texture2D(diff,texcoord);
	vec3 bgColor=texture2D(tex,texcoord).xyz;
	
	vec2 UV=texcoord.xy;//*0.5+0.5;
	UV+=normal.xy*0.025;
	
	float A=max(color.a-(1.0-alpha),0.0);
	vec3 refractedColor=texture2D(tex,UV).xyz*color.xyz;
	
	gl_FragColor.xyz = mix(bgColor,refractedColor,A);
}
